/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aetherfabric.events.CancellableCallback;
import com.aetherteam.aetherfabric.events.PlayerEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.apache.commons.lang3.mutable.MutableFloat;

public class ToolAbilityListener {
    public static void listen() {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> ToolAbilityListener.doHolystoneAbility(player, world, pos, player.method_6047(), state));
        PlayerEvents.ON_BLOCK_DESTROY.register(ToolAbilityListener::modifyBreakSpeed);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ToolAbilityListener.setupDebuffToolState(handler.method_32311()));
    }

    public static void doHolystoneAbility(class_1657 player, class_1937 level, class_2338 blockPos, class_1799 itemStack, class_2680 blockState) {
        AbilityHooks.ToolHooks.handleHolystoneToolAbility(player, level, blockPos, itemStack, blockState);
    }

    public static void modifyBreakSpeed(class_1657 player, class_2680 blockState, MutableFloat speed, CancellableCallback callback) {
        class_1799 itemStack = player.method_6047();
        if (!callback.isCanceled()) {
            speed.setValue(AbilityHooks.ToolHooks.handleZaniteToolAbility(itemStack, speed.getValue().floatValue()));
            speed.setValue(AbilityHooks.ToolHooks.reduceToolEffectiveness(player, blockState, itemStack, speed.getValue().floatValue()));
        }
    }

    public static void setupDebuffToolState(class_3222 player) {
        AbilityHooks.ToolHooks.setDebuffToolsState(player);
    }

    public static void doGoldenOakStripping(class_1936 levelAccessor, class_2680 oldState, class_1799 itemStack, class_1838 context) {
        AbilityHooks.ToolHooks.stripGoldenOak(levelAccessor, oldState, itemStack, context);
    }
}

